qui {
set output error

noi {
	/*************************************************/
	/****** Step 2.2. Simulate counterfactuals *******/
	/*************************************************/
}
	
	* Identify all NICs with sufficient data
	cd ..
	cd "./3. Intermediary results/3.4. Intermediaries"
	global NICs
	local max = 0
	foreach cntry of numlist 1/400 {
		cap confirm file data_10_`cntry'.dta
		if _rc == 0 {
			local max = `max'+1
			global NICs $NICs `cntry'
			}
		}
	cd ..
	
	* Run SCM algorithm
	local count = 0
	global max = `max'
	foreach NIC in $NICs {
		
		local count = `count'+1
		noi di ""
		noisily di "Synthetic control method: newly independent cntry `count'/$max [" c(current_date) " : " c(current_time) "], specification:", _continue
		foreach specification of numlist 1/2 {
			
			noi di `specification', _continue
			
			* Clean data (remove incomplete simulations)
			cd ".\3.1. Simulated gaps\3.1.1.1. Weights"
			cap confirm file cntry_weights`specification'_`NIC'.dta
			if _rc != 0 {
				cd .. 
				cd ..
				cd ".\3.2. Individual pseudo-gaps\3.2.2. Intermediaries"
				capture erase placebo`specification'_`NIC'.dta
				}
			cd ..
			cd ..
				
			* Check which cases still needed to be simulated
			cd ".\3.2. Individual pseudo-gaps\3.2.2. Intermediaries"
			capture confirm file placebo`specification'_`NIC'.dta
			cd ..
			cd ..
			if _rc != 0 {
			
				cd ".\3.4. Intermediaries"
				if `specification' == 1 {
				
					local identifier = "_10_"
					use data_10_`NIC', clear
					
					}
				if `specification' == 2 {
				
					local identifier = "_15_"
					use data_15_`NIC', clear
					
					}

				cd ..
				cd ..
				
				* Gather MSPE info
				preserve 
				keep earliest_* last_* preind* independence_year
				ds
				restore
				
				foreach input in `r(varlist)' {
					sum `input'
					local `input' = `r(mean)'
					}
					
				* Check data availability of covariates
				global SCM_covariates_1
				foreach var in $SCM_covariates {
					if "`var'" != "baseline_gdpcap" {
					cap sum earliest_year_`var'
						if _rc == 0 {
							if `earliest_year_`var'' <= `preindependence_year_1' {
								global SCM_covariates_1 $SCM_covariates_1 `var'(`earliest_year_`var''/`preindependence_year_1')
								}
							}
						}
					}
					
				* Perform simulation for this NIC
				cap noi synth baseline_gdpcap baseline_gdpcap(`earliest_year_baseline_gdpcap'(1)`preindependence_year_1') $SCM_covariates_1 , mspeperiod(`earliest_year_baseline_gdpcap'/`preindependence_year_1') resultsperiod(`earliest_year'/`last_year') trunit(`NIC') trperiod(`independence_year') nested allopt
				if _rc != 0 {
					*If no convergence is reached: apply the second-most accurate (nested) approach
					cap synth baseline_gdpcap baseline_gdpcap(`earliest_year_baseline_gdpcap'(1)`preindependence_year_1') $SCM_covariates_1 , mspeperiod(`earliest_year_baseline_gdpcap'/`preindependence_year_1') resultsperiod(`earliest_year'/`last_year') trunit(`NIC') trperiod(`independence_year') nested
					if _rc != 0 {
						*If no convergence is reached: use the third-most accurate (regression-based) approach
						cap synth baseline_gdpcap baseline_gdpcap(`earliest_year_baseline_gdpcap'(1)`preindependence_year_1') $SCM_covariates_1 , mspeperiod(`earliest_year_baseline_gdpcap'/`preindependence_year_1') resultsperiod(`earliest_year'/`last_year') trunit(`NIC') trperiod(`independence_year')
						}
					}
				else if _rc == 0 {
					matrix cntry_weights = e(W_weights)
					local check_weights = cntry_weights[1,2]
					if `check_weights' == . {
						noi di "missing weights, re-estimate"
							cap synth baseline_gdpcap baseline_gdpcap(`earliest_year_baseline_gdpcap'(1)`preindependence_year_1') $SCM_covariates_1 , mspeperiod(`earliest_year_baseline_gdpcap'/`preindependence_year_1') resultsperiod(`earliest_year'/`last_year') trunit(`NIC') trperiod(`independence_year') nested
							}
						}
								
				* Save results matrices
					
					* weights
					matrix cntry_weights`specification'_`NIC' = e(W_weights)
					matsave cntry_weights`specification'_`NIC', replace p(".\3. Intermediary results\3.1. Simulated gaps\3.1.1.1. Weights") saving
						
					* balance
					matrix balance`specification'_`NIC' =  e(X_balance)
					matsave balance`specification'_`NIC', replace  p(".\3. Intermediary results\3.1. Simulated gaps\3.1.1.2. Balance") saving
				
				* Perform placebo-simulations for control group
				scalar numberofcontrols = rowsof(cntry_weights`specification'_`NIC')
				local numberofcontrols = numberofcontrols
				global looprange = `numberofcontrols'
				noi di ""
				noisily di "# Placebo gaps to estimate = `numberofcontrols'", _continue
				
				* Parallel simulation procedure
				
					* Clean data (remove incomplete simulations)

					cd ".\3. Intermediary results\3.2. Individual pseudo-gaps\3.2.2. Intermediaries"
					forval j= 1 /`numberofcontrols' {

						* Check whether the simulation was initiated
						capture confirm file controle`specification'_`NIC'_`j'.dta
						if _rc == 0 {	
							
							* If so: check whether it was finished
							cd ..
							cd ".\3.2.1. Weights"
							capture confirm file cntry_weights`specification'_`NIC'_`j'.dta
							if _rc != 0 {	
								
								cd ..
								cd ".\3.2.2. Intermediaries"
								
								* If not: remove indicator and loop over it again
								erase controle`specification'_`NIC'_`j'.dta
								}
								
							}
							
						}
					cd ..
					cd ..
					cd ..
					
					* Save data for usage in parallel computation procedure
					cd "./3. Intermediary results"
					gen str identifier = "`identifier'"
					gen specification = `specification'
					gen NIC = `NIC'
					gen looprange = `numberofcontrols'
					save data, replace
					clear all
					
					* Run computations						
					cd ..
					cd ".\1. Dofiles"
					parallel setclusters $numberofclusters, force
					noi parallel do "2.2.b. Parallel loop.do", nodata
					noisily di ": done"
					noisily di ""
					
					* Erase unnecessary information
					cd ..
					cd "./3. Intermediary results"
					use data, clear
					erase data.dta
											
					* Indicate everything is estimated
					cd ".\3.2. Individual pseudo-gaps\3.2.1. Weights"
					cap confirm file cntry_weights`specification'_`NIC'_`numberofcontrols'.dta
					if _rc == 0 {
						cd ..
						cd ".\3.2.2. Intermediaries"
						gen n = _n
						keep if n == 1
						keep n
						save placebo`specification'_`NIC', replace
						cd ..
						cd ..
						}
					else if _rc != 0 {
						cd ..
						cd ..
						}
					}
				}
			}
	
	* Reroute to directory containing dofiles
	cd ..
	cd ".\1. Dofiles"
	}
